ORCA/M Asm65816 2.1.0

0001 871C
0002 871C
0003 871C              ***          Copyright Apple Computer, Inc. 1985-1989        ***
0004 871C              ***          All Rights Reserved                             ***
0005 871C
0006 871C
0007 871C              ***	include 'all.macros'	;removed 17-Sep-90 DAL
0008 871C                       include 'm16.util2' 
0009 871C                       include 'Snd.Equ.aii' 
0010 871C
0011 871C
0012 871C              ********************************************************
0013 871C              *
0014 871C              * 08 Aug 90  Braz
0015 871C              *
0016 871C              * Removed odd oscillator code to prevent trashing 
0017 871C              * one shot mode set up by FFSetUpSound.
0018 871C              *
0019 871C              * FFSetUpSound now always leaves odd osc in swap halted.
0020 871C              *
0021 871C              ********************************************************
0022 871C
0023 871C
0024 871C
0025 871C
0026 871C
0027 871C
0028 871C
0029 871C
0030 871C              ********************************************************
0031 871C              *
0032 871C              * StartPlaying
0033 871C              *
0034 871C              * This call Takes a word and for each bit set clears the halt bit for the
0035 871C              * Corresponding generator.
0036 871C              *
0037 871C              * Note: If the generator numbering ever changes this call will have to change.
0038 871C              *
0039 871C              ********************************************************
0040 871C
0041 871C              StartPlaying PROC EXPORT 
0042 871C
0043 871C                       import osctable 
0044 871C
0045 871C                       longa on
0046 871C                       longi on
0047 871C
0048 871C 0B                    phd                            ; save callers dp.
0049 871D 5B                    tcd                            ; get my dp.
0050 871E F0 52                 beq   nostart                  ; no start err.
0051 8720
0052 8720 08                    php                            ; save state.
0053 8721 78                    sei                            ; disable interupts.
0054 8722 A2 10 00              ldx   #16                      ; gen number.
0055 8725 A3 0A                 lda   w1+3,s                   ; get the paramater.
0056 8727
0057 8727 F0 3A        nextgen  beq   exit
0058 8729
0059 8729 CA                    dex                            ; dec x to mark new generator.
0060 872A 0A                    asl   a                        ; set the carry flag, if osc x to be started.
0061 872B 90 FA                 bcc   nextgen                  ; if clear check nextgen.
0062 872D
0063 872D 48                    pha   
0064 872E E2 20                 shortm                         ; set a to 8 bits.
0065 8730 BF CA 85 02           lda   >osctable,x              ; get the actual osc to start.
0066 8734 18                    clc   
0067 8735 69 A0                 adc   #eocr                    ; add address to Ensonic Osc Control Reg.
0068 8737 8F 3E C0 E1           sta   gadrl                    ; point to the control byte for my gen.
0069 873B
0070 873B AF CA 00 E1           lda   >irq_volume              ; get vol, no inc, to doc.
0071 873F 8F 3C C0 E1           sta   gstatreg                 ; set to my mode. no inc, to doc.
0072 8743 AF 3D C0 E1           lda   gdatreg                  ; false read.
0073 8747 AF 3D C0 E1           lda   gdatreg                  ; get the contol value.
0074 874B A8                    tay                            ; save for now
0075 874C 29 0E                 and   #$0E                     ; get ie, M1, M0 bits.
0076 874E D0 07                 bne   @1                       ; if any are set then it just needs to be started.
0077 8750
0078 8750 98                    tya                            ; else it is realy supposed to be in swap mode.
0079 8751 09 0E                 ora   #$0E                     ; put in swap mode with IRQ,
0080 8753              *        tay                            ; save control reg.
0081 8753
0082 8753              *        lda   gadrl                    ; odd osc is still in loop mode.
0083 8753              *        pha                            ; save for now.
0084 8753              *        inc   a                        ; so point to it.
0085 8753              *        sta   gadrl
0086 8753              *        tya                            ; get control reg back (swap halted).
0087 8753              *        sta   gdatreg                  ; halt in swap mode odd osc.
0088 8753
0089 8753              *        pla                            ; get gadrl back for even osc.
0090 8753              *        sta   gadrl                    ; point to even osc.
0091 8753              *        tya                            ; get control reg back (swap halted).
0092 8753 29 FE                 and   #$FE                     ; start it.
0093 8755              *        sta   gdatreg                  ; reset mode for odd osc.
0094 8755 80 03                 bra   @2                       ; continue checking
0095 8757 98           @1       tya                            ; get my control value back.
0096 8758 29 FE                 and   #$FE                     ; clear the low bit (halt bit).
0097 875A 8F 3D C0 E1  @2       sta   gdatreg                  ; start the generator.
0098 875E C2 20                 longm                          ; set a to 16 bits.
0099 8760 68                    pla                            ; get the paramater back.
0100 8761 D0 C4                 bne   nextgen                  ; if bits set we aren't done.
0101 8763
0102 8763 A2 00 00     exit     ldx   #0                       ; no error.
0103 8766 28                    plp                            ; restore interupts.
0104 8767 2B A2 00 00           endc 2                         ; quit, pop paramater, and replace dp.
0105 8772
0106 8772 A2 12 08     nostart  ldx   #NotInitted              ; sound tools weren't started.
0107 8775 2B A0 02 00           eout 2                         ; quit, pop paramater, report err, and replace dp.
0108 877D              ;
0109 877D              ; >>>--- exit Start Playing --->>>
0110 877D              ;
0111 877D              ;
0112 877D
0113 877D                       ENDP 
0114 877D
0115 877D
0116 877D                       END   
